<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminVehicleController.php';

$currentPage = 'vehicle_verifications';
$controller = new AdminVehicleController();
$vehicleId = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$vehicleId || !($vehicle = $controller->getVehicleDetails($vehicleId))) {
    setAlert('Vehículo no encontrado.', 'error');
    header('Location: vehicle_verifications.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Detalles del Vehículo - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>
    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4">
            <h1 class="text-xl font-bold text-gray-800">Revisión de Vehículo: <?php echo htmlspecialchars($vehicle['plate_number']); ?></h1>
        </header>
        <main class="p-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Información del Contribuyente</h2>
                    <p><strong>Documento:</strong> <?php echo htmlspecialchars($vehicle['document_number']); ?></p>
                    <p><strong>Nombre/Razón Social:</strong> <?php echo htmlspecialchars($vehicle['company_name'] ?: $vehicle['first_name'] . ' ' . $vehicle['last_name']); ?></p>
                    
                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Datos del Vehículo</h2>
                    <p><strong>Placa:</strong> <?php echo htmlspecialchars($vehicle['plate_number']); ?></p>
                    <p><strong>Marca:</strong> <?php echo htmlspecialchars($vehicle['brand']); ?></p>
                    <p><strong>Modelo:</strong> <?php echo htmlspecialchars($vehicle['model']); ?></p>
                    <p><strong>Año:</strong> <?php echo htmlspecialchars($vehicle['year']); ?></p>
                    <p><strong>Tipo:</strong> <?php echo ucfirst(htmlspecialchars($vehicle['vehicle_type'])); ?></p>
                </div>
                
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h2 class="text-lg font-semibold border-b pb-2 mb-4">Documento Adjunto</h2>
                    <?php if ($vehicle['file_path']): ?>
                        <a href="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($vehicle['file_path']); ?>" target="_blank" class="text-blue-600 hover:underline flex items-center">
                            <i class="fas fa-file-pdf mr-2"></i> <?php echo htmlspecialchars($vehicle['file_name']); ?>
                        </a>
                    <?php else: ?>
                        <p class="text-gray-500">No se adjuntó ningún documento.</p>
                    <?php endif; ?>

                    <h2 class="text-lg font-semibold border-b pb-2 mt-6 mb-4">Acciones</h2>
                    <form action="actions/admin_vehicle_actions.php" method="POST">
                        <input type="hidden" name="vehicle_id" value="<?php echo $vehicle['id']; ?>">
                        
                        <div class="mb-4">
                            <label for="rejection_reason" class="block text-sm font-medium text-gray-700">Motivo del Rechazo (si aplica)</label>
                            <textarea name="rejection_reason" id="rejection_reason" rows="3" class="w-full mt-1 form-input"></textarea>
                        </div>

                        <div class="flex flex-col space-y-2">
                            <button type="submit" name="action" value="approve" class="w-full bg-green-600 text-white py-2 rounded-lg hover:bg-green-700 transition">
                                <i class="fas fa-check-circle mr-2"></i>Aprobar y Generar Impuesto
                            </button>
                            <button type="submit" name="action" value="reject" class="w-full bg-red-600 text-white py-2 rounded-lg hover:bg-red-700 transition">
                                <i class="fas fa-times-circle mr-2"></i>Rechazar
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>