<?php
require_once '../config/config.php';
requireAdmin();
require_once 'controllers/AdminVehicleController.php';

$currentPage = 'vehicle_verifications';
$controller = new AdminVehicleController();
$pendingVehicles = $controller->getPendingVehicles();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Verificación de Vehículos - Admin</title>
    <?php include 'partials/head.php'; ?>
</head>
<body class="bg-gray-100">
    <?php include 'partials/sidebar.php'; ?>

    <div class="main-content">
        <header class="bg-white shadow-sm border-b p-4">
            <h1 class="text-xl font-bold text-gray-800">Vehículos Pendientes de Verificación</h1>
        </header>

        <main class="p-6">
            <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="p-3 text-left">Fecha Solicitud</th>
                            <th class="p-3 text-left">Contribuyente</th>
                            <th class="p-3 text-left">Placa</th>
                            <th class="p-3 text-left">Marca / Modelo</th>
                            <th class="p-3 text-left">Año</th>
                            <th class="p-3 text-center">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($pendingVehicles)): ?>
                            <tr><td colspan="6" class="p-4 text-center text-gray-500">No hay vehículos pendientes por verificar.</td></tr>
                        <?php else: ?>
                            <?php foreach ($pendingVehicles as $vehicle): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo formatDateTime($vehicle['created_at']); ?></td>
                                    <td class="p-3 text-sm">
                                        <?php echo htmlspecialchars($vehicle['document_number']); ?><br>
                                        <small><?php echo htmlspecialchars($vehicle['company_name'] ?: $vehicle['first_name'] . ' ' . $vehicle['last_name']); ?></small>
                                    </td>
                                    <td class="p-3 text-sm font-mono"><?php echo htmlspecialchars($vehicle['plate_number']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($vehicle['brand'] . ' / ' . $vehicle['model']); ?></td>
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($vehicle['year']); ?></td>
                                    <td class="p-3 text-center">
                                        <a href="vehicle_details.php?id=<?php echo $vehicle['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded hover:bg-blue-600">
                                            <i class="fas fa-search mr-1"></i>Revisar
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
    <script src="assets/js/main.js"></script>
</body>
</html>