<?php
// config/config.php
session_start();

// Configuración de zona horaria
date_default_timezone_set('America/Caracas');

// Configuración de errores (cambiar en producción)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Rutas del sistema
define('BASE_URL', 'http://localhost/sistema-municipal/');
define('BASE_PATH', dirname(dirname(__FILE__)) . '/');
define('UPLOAD_PATH', BASE_PATH . 'assets/uploads/');
define('ADMIN_PATH', BASE_PATH . 'admin/');

// Incluir archivos necesarios
require_once BASE_PATH . 'config/database.php';
require_once BASE_PATH . 'includes/functions.php';
require_once BASE_PATH . 'includes/auth.php';
require_once BASE_PATH . 'includes/currency.php';

// Inicializar base de datos
$db = Database::getInstance();

// Cargar configuración del sistema
function getSystemConfig($key = null) {
    global $db;
    
    if ($key) {
        $stmt = $db->query("SELECT config_value FROM system_config WHERE config_key = ?", [$key]);
        $result = $stmt->fetch();
        return $result ? $result['config_value'] : null;
    }
    
    $stmt = $db->query("SELECT config_key, config_value FROM system_config");
    $config = [];
    while ($row = $stmt->fetch()) {
        $config[$row['config_key']] = $row['config_value'];
    }
    return $config;
}

// Configuración global
$GLOBALS['system_config'] = getSystemConfig();
?>
