<?php
// Script para generar un hash de contraseña seguro.

// --- CONFIGURACIÓN ---
// Escribe aquí la contraseña que quieres encriptar
$contrasenaPlana = '12345678';
// -------------------

// Generar el hash usando el algoritmo por defecto y más seguro de PHP
$hash = password_hash($contrasenaPlana, PASSWORD_DEFAULT);

// Mostrar el resultado en pantalla
echo "<!DOCTYPE html><html lang='es'><head><title>Generador de Hash</title>";
echo "<style>
        body { font-family: sans-serif; padding: 2em; background-color: #f4f4f9; color: #333; }
        .container { max-width: 800px; margin: auto; background: white; padding: 2em; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        h1 { color: #5a2d82; }
        code { background-color: #eee; padding: 0.5em; border-radius: 4px; font-family: monospace; word-break: break-all; }
        p { line-height: 1.6; }
      </style>";
echo "</head><body><div class='container'>";
echo "<h1>Generador de Hash de Contraseña</h1>";
echo "<p>Contraseña en texto plano: <strong>" . htmlspecialchars($contrasenaPlana) . "</strong></p>";
echo "<p>Hash seguro generado:</p>";
echo "<code>" . htmlspecialchars($hash) . "</code>";
echo "<hr style='margin: 2em 0;'>";
echo "<h2>¿Cómo usarlo?</h2>";
echo "<p>Copia el hash generado y úsalo en tu sentencia SQL para insertar o actualizar un usuario. Por ejemplo:</p>";
echo "<pre><code>UPDATE users SET password = '" . htmlspecialchars($hash) . "' WHERE email = 'contribuyente.demo@email.com';</code></pre>";
echo "</div></body></html>";

?>