<?php
// Script de prueba para verificar la contraseña de un usuario directamente.

// 1. Incluir la configuración para tener acceso a la base de datos.
require_once 'config/config.php';

echo "<!DOCTYPE html><html lang='es'><head><title>Test de Contraseña</title>";
echo "<style>body { font-family: sans-serif; padding: 2em; } .success { color: green; font-weight: bold; } .error { color: red; font-weight: bold; }</style>";
echo "</head><body>";
echo "<h1>Prueba de Verificación de Contraseña</h1>";

// --- CONFIGURACIÓN DE LA PRUEBA ---
$documento_a_probar = 'V12345678';
$contrasena_a_probar = '12345678';
// ------------------------------------

echo "<p>Probando el documento: <strong>" . htmlspecialchars($documento_a_probar) . "</strong></p>";
echo "<p>Probando la contraseña: <strong>" . htmlspecialchars($contrasena_a_probar) . "</strong></p>";
echo "<hr>";

// 2. Obtener la instancia de la base de datos.
$db = Database::getInstance()->getConnection();

// 3. Buscar al usuario en la base de datos.
try {
    $stmt = $db->prepare("SELECT * FROM users WHERE document_number = ?");
    $stmt->execute([$documento_a_probar]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        echo "<p>Usuario encontrado en la base de datos:</p>";
        echo "<pre>" . print_r($user, true) . "</pre>";
        
        $hash_guardado = $user['password'];
        echo "<p>Hash de la contraseña guardado en la BD:</p>";
        echo "<pre>" . htmlspecialchars($hash_guardado) . "</pre>";

        // 4. Usar password_verify() para comparar.
        echo "<p>Verificando si la contraseña coincide con el hash...</p>";
        
        if (password_verify($contrasena_a_probar, $hash_guardado)) {
            echo "<p class='success'>¡ÉXITO! La contraseña es correcta.</p>";
        } else {
            echo "<p class='error'>¡ERROR! La contraseña NO coincide con el hash guardado.</p>";
            
            // Ayuda adicional para depurar
            echo "<hr>";
            echo "<h2>Posibles Soluciones:</h2>";
            echo "<ol>";
            echo "<li>Asegúrate de que el hash en la base de datos fue creado con <strong>password_hash()</strong> de PHP.</li>";
            echo "<li>Si copiaste el hash manualmente, algún caracter podría haberse perdido. Intenta generar un nuevo usuario desde el formulario de registro.</li>";
            echo "<li>El campo 'password' en tu tabla 'users' debe tener una longitud suficiente (VARCHAR 255 es lo recomendado).</li>";
            echo "</ol>";
        }

    } else {
        echo "<p class='error'>¡ERROR! No se encontró ningún usuario con el documento '" . htmlspecialchars($documento_a_probar) . "'.</p>";
    }

} catch (PDOException $e) {
    echo "<p class='error'>Error de base de datos: " . $e->getMessage() . "</p>";
}

echo "</body></html>";
?>