<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../../config/config.php';
requireAuth();
require_once '../controllers/CitizenTaxController.php';

$user = $auth->getUser();
$controller = new CitizenTaxController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    
    $action = $_POST['action'];
    
    if ($action === 'declarar_vehiculo_para_revision') {
        
        // Llamamos a la nueva función del controlador, pasando los datos del POST y del FILES.
        $result = $controller->requestVehicleVerification($user['id'], $_POST, $_FILES);
        
        setAlert($result['message'], $result['success'] ? 'success' : 'error');

        if ($result['success']) {
            // Si todo salió bien, lo enviamos a una nueva página donde vea sus vehículos.
            // Por ahora, lo enviaremos al dashboard.
            header('Location: ../dashboard.php');
        } else {
            // Si hubo un error, lo regresamos al formulario para que corrija.
            header('Location: ../declarar-vehiculo.php');
        }
        exit;
    }
}

// Redirigir si se accede sin una acción válida
header('Location: ../dashboard.php');
exit;
?>