<?php
require_once '../../config/config.php';
requireAuth();
require_once '../controllers/LicenseController.php';

$user = $auth->getUser();
$controller = new LicenseController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    
    if ($_POST['action'] === 'request_license') {
        $activityId = filter_input(INPUT_POST, 'activity_id', FILTER_VALIDATE_INT);
        
        if ($activityId) {
            $result = $controller->createLicenseRequest($user['id'], $activityId);
            setAlert($result['message'], $result['success'] ? 'success' : 'error');
        } else {
            setAlert('Debe seleccionar una actividad económica.', 'error');
        }

        header('Location: ../licencias.php');
        exit;
    }
}

header('Location: ../dashboard.php');
exit;
?>