<?php
require_once '../../config/config.php';
requireAuth();
require_once '../controllers/PaymentController.php';

$user = $auth->getUser();
$controller = new PaymentController();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    
    $action = $_POST['action'];
    
    if ($action === 'report_payment') {
        
        // Llamamos al controlador con los datos del POST y FILES
        $result = $controller->reportPayment($user['id'], $_POST, $_FILES);
        
        // Guardamos el mensaje en la sesión para mostrarlo en la siguiente página
        setAlert($result['message'], $result['success'] ? 'success' : 'error');
        
        // Redirigimos al usuario a su estado de cuenta
        header('Location: ../mis-impuestos.php');
        exit;
    }
}

// Si se accede al archivo sin una acción válida, redirigir al dashboard
header('Location: ../dashboard.php');
exit;
?>