<?php
class ActivityController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Procesa la solicitud de registro de una nueva Actividad Económica.
     * @param int $userId El ID del usuario que registra.
     * @param array $data Los datos del formulario ($_POST).
     * @param array $file El archivo adjunto ($_FILES).
     * @return array Resultado de la operación ['success' => bool, 'message' => string].
     */
    public function requestActivityVerification($userId, $data, $file) {
        if (!isset($file['documento_actividad']) || $file['documento_actividad']['error'] !== UPLOAD_ERR_OK) {
            return ['success' => false, 'message' => 'Error al subir el documento de soporte.'];
        }

        $sqlActivity = "INSERT INTO economic_activities (user_id, activity_code, description, status) 
                        VALUES (?, ?, ?, 'pending_verification')";
        
        $paramsActivity = [$userId, $data['activity_code'], $data['description']];
        $stmtActivity = $this->db->query($sqlActivity, $paramsActivity);

        if (!$stmtActivity) {
            return ['success' => false, 'message' => 'Error al registrar la actividad económica.'];
        }
        $activityId = $this->db->lastInsertId();

        $uploadResult = uploadFile($file['documento_actividad'], 'activity_documents');
        if (!$uploadResult['success']) {
            return ['success' => false, 'message' => 'Error al guardar el documento: ' . $uploadResult['message']];
        }

        $sqlAttachment = "INSERT INTO attachments (entity_type, entity_id, file_name, file_path, file_type, file_size, uploaded_by)
                          VALUES ('economic_activity', ?, ?, ?, ?, ?, ?)";
        
        $paramsAttachment = [
            $activityId, $file['documento_actividad']['name'], $uploadResult['path'], 
            $file['documento_actividad']['type'], $file['documento_actividad']['size'], $userId
        ];
        $stmtAttachment = $this->db->query($sqlAttachment, $paramsAttachment);

        if ($stmtAttachment) {
            logActivity('activity_registration_sent', 'economic_activities', $activityId);
            return ['success' => true, 'message' => '¡Solicitud enviada! Su actividad económica será revisada y notificada cuando sea aprobada.'];
        } else {
            // Opcional: Borrar el registro de la actividad si falla el adjunto
            $this->db->query("DELETE FROM economic_activities WHERE id = ?", [$activityId]);
            return ['success' => false, 'message' => 'Se registró la actividad pero falló al guardar el adjunto.'];
        }
    }
}
?>