<?php
class DashboardController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Obtiene las estadísticas clave para el dashboard del ciudadano.
     * @param int $userId El ID del usuario.
     * @return array Un array con las estadísticas.
     */
    public function getCitizenDashboardStats($userId) {
        $stats = [];

        // 1. Impuestos Pendientes
        $stmt_taxes = $this->db->query(
            "SELECT COUNT(*) as count, SUM(t.amount) as total 
             FROM taxes t
             JOIN currencies c ON t.currency_id = c.id
             WHERE t.user_id = ? AND t.status IN ('pending', 'overdue')",
            [$userId]
        );
        $taxData = $stmt_taxes->fetch();
        $stats['pending_taxes_count'] = $taxData['count'] ?? 0;
        $stats['pending_taxes_total'] = $taxData['total'] ?? 0;

        // 2. Propiedades Registradas y Verificadas
        $stmt_properties = $this->db->query(
            "SELECT COUNT(*) as count FROM properties WHERE user_id = ? AND status = 'verified'",
            [$userId]
        );
        $stats['verified_properties_count'] = $stmt_properties->fetch()['count'] ?? 0;

        // 3. Reportes Ciudadanos
        $stmt_reports = $this->db->query(
            "SELECT status, COUNT(*) as count FROM citizen_reports WHERE user_id = ? GROUP BY status",
            [$userId]
        );
        $reports = $stmt_reports->fetchAll();
        $stats['reports_total'] = 0;
        $stats['reports_resolved'] = 0;
        $stats['reports_in_progress'] = 0;

        foreach ($reports as $report) {
            $stats['reports_total'] += $report['count'];
            if ($report['status'] === 'resolved' || $report['status'] === 'closed') {
                $stats['reports_resolved'] += $report['count'];
            }
            if ($report['status'] === 'in_progress') {
                $stats['reports_in_progress'] += $report['count'];
            }
        }
        
        return $stats;
    }
}
?>