<?php
class NotificationController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * Obtiene las notificaciones no leídas de un usuario.
     * @param int $userId El ID del usuario.
     * @return array La lista de notificaciones.
     */
    public function getUnreadNotifications($userId) {
        $sql = "SELECT * FROM notifications WHERE user_id = ? AND is_read = FALSE ORDER BY created_at DESC LIMIT 5";
        $stmt = $this->db->query($sql, [$userId]);
        return $stmt->fetchAll();
    }
}
?>