<?php
require_once '../config/config.php';
requireAuth();
$user = $auth->getUser();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crear Reporte Ciudadano - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4"><h2 class="text-xl font-semibold">Crear Nuevo Reporte Ciudadano</h2></header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-3xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    <form action="actions/report_actions.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="create_report">
                        <div class="space-y-6">
                            <div>
                                <label for="category" class="block text-sm font-medium mb-2">Categoría del Reporte</label>
                                <select name="category" id="category" class="w-full px-3 py-2 border rounded-lg" required>
                                    <option value="">Seleccione una categoría...</option>
                                    <option value="Alumbrado Público">Alumbrado Público</option>
                                    <option value="Botes de Agua">Botes de Agua</option>
                                    <option value="Recolección de Basura">Recolección de Basura</option>
                                    <option value="Semáforos">Semáforos</option>
                                    <option value="Vialidad">Vialidad (Huecos)</option>
                                    <option value="Otro">Otro</option>
                                </select>
                            </div>
                            <div>
                                <label for="title" class="block text-sm font-medium mb-2">Título del Reporte</label>
                                <input type="text" name="title" id="title" class="w-full px-3 py-2 border rounded-lg" placeholder="Ej: Poste de luz sin funcionar" required>
                            </div>
                            <div>
                                <label for="description" class="block text-sm font-medium mb-2">Descripción Detallada</label>
                                <textarea name="description" id="description" rows="4" class="w-full px-3 py-2 border rounded-lg" placeholder="Describa el problema con la mayor cantidad de detalles posible." required></textarea>
                            </div>
                            <div>
                                <label for="location" class="block text-sm font-medium mb-2">Ubicación / Dirección</label>
                                <input type="text" name="location" id="location" class="w-full px-3 py-2 border rounded-lg" placeholder="Ej: Av. Principal, frente a la panadería" required>
                            </div>
                            <div>
                                <label for="report_file" class="block text-sm font-medium mb-2">Adjuntar Foto (Opcional)</label>
                                <input type="file" name="report_file" id="report_file" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0">
                            </div>
                        </div>
                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-reportes.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-paper-plane mr-2"></i>Enviar Reporte
                            </button>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>