<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/NotificationController.php';
require_once 'controllers/DashboardController.php'; // Incluimos el nuevo controlador

$user = $auth->getUser();

$notificationController = new NotificationController();
$notifications = $notificationController->getUnreadNotifications($user['id']);

$dashboardController = new DashboardController();
$stats = $dashboardController->getCitizenDashboardStats($user['id']);
$defaultCurrency = $currency->getDefaultCurrency();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Escritorio del Contribuyente - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4 flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-700">Escritorio del Contribuyente</h2>
                <div class="flex items-center space-x-4">
                    <span class="text-gray-600">
                        Bienvenido, 
                        <span class="font-bold">
                            <?php echo htmlspecialchars($user['user_type'] === 'natural' ? $user['first_name'] . ' ' . $user['last_name'] : $user['company_name']); ?>
                        </span>
                    </span>
                    <i class="fas fa-user-circle text-2xl text-gray-500"></i>
                </div>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                    
                    <a href="mis-impuestos.php" class="block p-6 rounded-xl shadow-lg bg-gradient-to-br from-red-500 to-orange-500 text-white transform hover:-translate-y-1 transition-transform duration-300">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="text-4xl font-bold"><?php echo $stats['pending_taxes_count']; ?></p>
                                <p class="text-lg font-semibold">Impuestos Pendientes</p>
                            </div>
                            <div class="bg-white/30 p-3 rounded-full">
                                <i class="fas fa-file-invoice-dollar fa-lg"></i>
                            </div>
                        </div>
                        <p class="text-sm mt-4">Total a pagar: <span class="font-bold"><?php echo $defaultCurrency['symbol'] . ' ' . number_format($stats['pending_taxes_total'], 2); ?></span></p>
                    </a>

                    <a href="mis-inmuebles.php" class="block p-6 rounded-xl shadow-lg bg-gradient-to-br from-blue-500 to-sky-500 text-white transform hover:-translate-y-1 transition-transform duration-300">
                         <div class="flex justify-between items-start">
                            <div>
                                <p class="text-4xl font-bold"><?php echo $stats['verified_properties_count']; ?></p>
                                <p class="text-lg font-semibold">Propiedades Registradas</p>
                            </div>
                            <div class="bg-white/30 p-3 rounded-full">
                                <i class="fas fa-home fa-lg"></i>
                            </div>
                        </div>
                        <p class="text-sm mt-4">Inmuebles verificados y activos</p>
                    </a>
                    
                    <a href="mis-reportes.php" class="block p-6 rounded-xl shadow-lg bg-gradient-to-br from-green-500 to-teal-500 text-white transform hover:-translate-y-1 transition-transform duration-300">
                         <div class="flex justify-between items-start">
                            <div>
                                <p class="text-4xl font-bold"><?php echo $stats['reports_total']; ?></p>
                                <p class="text-lg font-semibold">Mis Reportes Ciudadanos</p>
                            </div>
                            <div class="bg-white/30 p-3 rounded-full">
                                <i class="fas fa-bullhorn fa-lg"></i>
                            </div>
                        </div>
                        <p class="text-sm mt-4"><?php echo $stats['reports_resolved']; ?> resueltos, <?php echo $stats['reports_in_progress']; ?> en progreso</p>
                    </a>

                </div>

                <?php if (!empty($notifications)): ?>
                <div class="bg-white p-6 rounded-lg shadow-md">
                    <h3 class="font-bold text-gray-800 text-lg mb-4">Notificaciones Recientes</h3>
                    <ul class="space-y-3">
                        <?php foreach ($notifications as $notification): ?>
                        <li class="text-sm p-4 rounded-lg bg-blue-50 border border-blue-200 text-blue-800">
                            <i class="fas fa-info-circle mr-3"></i>
                            <a href="<?php echo htmlspecialchars($notification['link'] ?? '#'); ?>" class="hover:underline">
                                <?php echo htmlspecialchars($notification['message']); ?>
                                <span class="text-xs text-gray-500 ml-2">(<?php echo formatDateTime($notification['created_at']); ?>)</span>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

            </main>
        </div>
    </div>
</body>
</html>