<?php
require_once '../config/config.php';
requireAuth();
$user = $auth->getUser();
$activity_id = filter_input(INPUT_GET, 'activity_id', FILTER_VALIDATE_INT);

// Verificar que se pasó un ID de actividad válido
if (!$activity_id) {
    setAlert('Debe seleccionar una actividad económica para declarar.', 'error');
    header('Location: mis-actividades.php');
    exit;
}

// Obtener detalles de la actividad para mostrarla en el formulario
$db = Database::getInstance();
$activity = $db->query("SELECT * FROM economic_activities WHERE id = ? AND user_id = ?", [$activity_id, $user['id']])->fetch();

if (!$activity || $activity['status'] !== 'active') {
    setAlert('La actividad seleccionada no es válida o no está activa.', 'error');
    header('Location: mis-actividades.php');
    exit;
}

// ---- INICIO DE LA CORRECCIÓN ----
// Creamos un formateador de fecha para obtener los nombres de los meses en español.
$formatter = new IntlDateFormatter('es_ES', IntlDateFormatter::FULL, IntlDateFormatter::NONE, null, null, 'MMMM');
// ---- FIN DE LA CORRECCIÓN ----

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Declaración de Ingresos Brutos (ISAE) - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4"><h2 class="text-xl font-semibold">Declaración de Ingresos Brutos (ISAE)</h2></header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    <div class="bg-gray-50 border p-4 rounded-lg mb-6">
                        <h3 class="font-bold text-gray-800">Actividad Económica a Declarar</h3>
                        <p class="text-gray-600"><strong>Código:</strong> <?php echo htmlspecialchars($activity['activity_code']); ?></p>
                        <p class="text-gray-600"><strong>Descripción:</strong> <?php echo htmlspecialchars($activity['description']); ?></p>
                    </div>

                    <form action="actions/isae_actions.php" method="POST">
                        <input type="hidden" name="action" value="declare_isae">
                        <input type="hidden" name="activity_id" value="<?php echo $activity['id']; ?>">

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="declaration_period_month" class="block text-sm font-medium mb-2">Mes del Período</label>
                                <select name="declaration_period_month" id="declaration_period_month" class="w-full px-3 py-2 border rounded-lg" required>
                                    <?php for ($m=1; $m<=12; $m++): 
                                        // ---- INICIO DE LA CORRECCIÓN ----
                                        // Usamos el nuevo formateador en lugar de strftime()
                                        $monthName = ucfirst($formatter->format(mktime(0, 0, 0, $m, 1)));
                                        // ---- FIN DE LA CORRECCIÓN ----
                                    ?>
                                    <option value="<?php echo $m; ?>" <?php echo ($m == date('n')-1) ? 'selected' : ''; ?>><?php echo $monthName; ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                            <div>
                                <label for="declaration_period_year" class="block text-sm font-medium mb-2">Año del Período</label>
                                <input type="number" name="declaration_period_year" id="declaration_period_year" value="<?php echo date('Y'); ?>" class="w-full px-3 py-2 border rounded-lg" required>
                            </div>
                            <div class="md:col-span-2">
                                <label for="gross_income" class="block text-sm font-medium mb-2">Total de Ingresos Brutos del Período (Bs.)</label>
                                <input type="number" step="0.01" name="gross_income" id="gross_income" class="w-full px-3 py-2 border rounded-lg" placeholder="0.00" required>
                            </div>
                        </div>

                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-actividades.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-calculator mr-2"></i>Calcular y Declarar
                            </button>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>