<?php
require_once '../config/config.php';
requireAuth();

$user = $auth->getUser();
$pageTitle = 'Declaración de Vehículo';
$vehicle = [
    'id' => '', 'plate_number' => '', 'year' => '', 'brand' => '', 'model' => '', 'vehicle_type' => ''
];

// Si se recibe un ID para editar, buscamos los datos del vehículo
if (isset($_GET['edit_id']) && is_numeric($_GET['edit_id'])) {
    $db = Database::getInstance();
    $stmt = $db->query(
        "SELECT * FROM vehicles WHERE id = ? AND user_id = ? AND status = 'rejected'",
        [$_GET['edit_id'], $user['id']]
    );
    $vehicleData = $stmt->fetch();
    
    if ($vehicleData) {
        $vehicle = $vehicleData;
        $pageTitle = 'Corregir Declaración de Vehículo';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4">
                <h2 class="text-xl font-semibold text-gray-700"><?php echo $pageTitle; ?></h2>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-2xl mx-auto">
                    
                    <?php if ($alert = getAlert()): ?>
                    <div class="p-4 rounded-lg mb-6 <?php echo $alert['type'] === 'error' ? 'bg-red-100 border border-red-400 text-red-700' : 'bg-green-100 border border-green-400 text-green-700'; ?>">
                        <div class="flex items-center">
                            <i class="fas <?php echo $alert['type'] === 'error' ? 'fa-exclamation-circle' : 'fa-check-circle'; ?> mr-3"></i>
                            <span><?php echo htmlspecialchars($alert['message']); ?></span>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="bg-white p-8 rounded-lg shadow-md">
                        <form action="actions/declaracion_actions.php" method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="action" value="declarar_vehiculo_para_revision">

                            <div class="border-b pb-4 mb-6">
                                <h3 class="text-lg font-semibold text-gray-800">Datos del Vehículo</h3>
                                <p class="text-sm text-gray-500">Introduzca la información y adjunte los documentos requeridos.</p>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="plate_number" class="block text-sm font-medium text-gray-700 mb-2">Placa del Vehículo</label>
                                    <input type="text" name="plate_number" id="plate_number" value="<?php echo htmlspecialchars($vehicle['plate_number']); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm" required>
                                </div>
                                <div>
                                    <label for="year" class="block text-sm font-medium text-gray-700 mb-2">Año del Modelo</label>
                                    <input type="number" name="year" id="year" value="<?php echo htmlspecialchars($vehicle['year']); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm" placeholder="<?php echo date('Y'); ?>" required>
                                </div>
                                <div>
                                    <label for="brand" class="block text-sm font-medium text-gray-700 mb-2">Marca</label>
                                    <input type="text" name="brand" id="brand" value="<?php echo htmlspecialchars($vehicle['brand']); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm" required>
                                </div>
                                <div>
                                    <label for="model" class="block text-sm font-medium text-gray-700 mb-2">Modelo</label>
                                    <input type="text" name="model" id="model" value="<?php echo htmlspecialchars($vehicle['model']); ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm" required>
                                </div>
                                <div class="md:col-span-2">
                                    <label for="vehicle_type" class="block text-sm font-medium text-gray-700 mb-2">Tipo de Vehículo</label>
                                    <select name="vehicle_type" id="vehicle_type" class="w-full px-3 py-2 border border-gray-300 rounded-lg shadow-sm" required>
                                        <option value="">Seleccione...</option>
                                        <option value="particular" <?php echo ($vehicle['vehicle_type'] == 'particular') ? 'selected' : ''; ?>>Particular</option>
                                        <option value="carga" <?php echo ($vehicle['vehicle_type'] == 'carga') ? 'selected' : ''; ?>>Carga</option>
                                        <option value="transporte_publico" <?php echo ($vehicle['vehicle_type'] == 'transporte_publico') ? 'selected' : ''; ?>>Transporte Público</option>
                                        <option value="motocicleta" <?php echo ($vehicle['vehicle_type'] == 'motocicleta') ? 'selected' : ''; ?>>Motocicleta</option>
                                    </select>
                                </div>
                                
                                <div class="md:col-span-2">
                                    <label for="documento_vehiculo" class="block text-sm font-medium text-gray-700 mb-2">Documento del Vehículo (PDF, JPG, PNG)</label>
                                    <input type="file" name="documento_vehiculo" id="documento_vehiculo" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100" required>
                                    <p class="text-xs text-gray-500 mt-1">Debe adjuntar el documento de nuevo, incluso si solo está corrigiendo los datos.</p>
                                </div>
                            </div>

                            <div class="mt-8 pt-6 border-t flex justify-end">
                                <a href="mis-vehiculos.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-300 transition mr-3">Cancelar</a>
                                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition flex items-center">
                                    <i class="fas fa-paper-plane mr-2"></i>
                                    Enviar para Revisión
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>