<?php
require_once '../config/config.php';
requireAuth();
require_once '../includes/libs/fpdf.php'; // Incluimos la librería FPDF

$user = $auth->getUser();
$solvency_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$solvency_id) {
    die("ID de solvencia no válido.");
}

// Buscar los datos de la solvencia y asegurarse de que pertenece al usuario logueado
$db = Database::getInstance();
$stmt = $db->query(
    "SELECT s.*, u.first_name, u.last_name, u.company_name, u.document_number 
     FROM solvencies s 
     JOIN users u ON s.user_id = u.id 
     WHERE s.id = ? AND s.user_id = ?",
    [$solvency_id, $user['id']]
);
$solvency = $stmt->fetch();

if (!$solvency) {
    die("Solvencia no encontrada o no tiene permiso para verla.");
}

// --- INICIO DE LA CREACIÓN DEL PDF ---

class PDF extends FPDF {
    // Cabecera de página
    function Header() {
        // Logo (usa el logo configurado en el sistema)
        $site_logo = getSystemConfig('site_logo');
        if ($site_logo && file_exists(UPLOAD_PATH . $site_logo)) {
            $this->Image(UPLOAD_PATH . $site_logo, 10, 8, 33);
        }
        
        $this->SetFont('Arial','B',12);
        $this->Cell(80); // Mover a la derecha
        $this->Cell(30,10,'CABEZERA 1',0,1,'C');
        $this->Cell(80);
        $this->Cell(30,5,'ALCALDÍA DE',0,1,'C');
        $this->Ln(20); // Salto de línea
    }

    // Pie de página
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Página ' . $this->PageNo(),0,0,'C');
    }
}

// Crear instancia del PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);

// Título del documento
$pdf->Cell(0,10,'CERTIFICADO ELECTRONICO DE SOLVENCIA MUNICIPAL',0,1,'C');
$pdf->Ln(10);

// Cuerpo del certificado
$pdf->SetFont('Arial','',12);

$nombre_completo = $solvency['company_name'] ?: $solvency['first_name'] . ' ' . $solvency['last_name'];
$documento = $solvency['document_number'];

$pdf->MultiCell(0, 8, "Por medio de la presente, se hace constar que el (la) contribuyente:", 0, 'J');
$pdf->Ln(5);

$pdf->SetFont('Arial','B',12);
$pdf->Cell(0, 8, $nombre_completo, 0, 1, 'C');
$pdf->Cell(0, 8, "C.I./R.I.F.: " . $documento, 0, 1, 'C');
$pdf->Ln(5);

$pdf->SetFont('Arial','',12);
$pdf->MultiCell(0, 8, "Se encuentra SOLVENTE con sus obligaciones tributarias municipales hasta la fecha de emisión de este certificado.", 0, 'J');
$pdf->Ln(10);

// Detalles del certificado
$pdf->SetFont('Arial','B',10);
$pdf->Cell(60, 8, "Fecha de Emisión:", 1, 0, 'C');
$pdf->SetFont('Arial','',10);
$pdf->Cell(0, 8, formatDate($solvency['issue_date']), 1, 1);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(60, 8, "Fecha de Vencimiento:", 1, 0, 'C');
$pdf->SetFont('Arial','',10);
$pdf->Cell(0, 8, formatDate($solvency['expiry_date']), 1, 1);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(60, 8, "Código Único de Verificación:", 1, 0, 'C');
$pdf->SetFont('Arial','',10);
$pdf->Cell(0, 8, $solvency['unique_code'], 1, 1);
$pdf->Ln(10);

$pdf->SetFont('Arial','I',10);
$pdf->MultiCell(0, 5, "La validez de este certificado puede ser verificada en el portal web de la alcaldía introduciendo el Código Único de Verificación.", 0, 'C');

// Salida del PDF
$pdf->Output('D', 'solvencia-'.$solvency['unique_code'].'.pdf');
exit;
?>