<?php
require_once '../config/config.php';

// Obtenemos las configuraciones guardadas por el admin para usarlas en la página
$site_name = getSystemConfig('site_name') ?: 'Sistema Municipal';
$site_logo = getSystemConfig('site_logo');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_name); ?> - Portal del Ciudadano</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .card-hover:hover {
            transform: translateY(-5px);
            transition: all 0.3s ease;
        }
        .currency-badge {
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.7; }
            100% { opacity: 1; }
        }
    </style>
</head>
<body class="bg-gray-50">
    <header class="gradient-bg text-white shadow-lg">
        <nav class="container mx-auto px-4 py-4">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-4">
                    <div class="bg-white p-2 rounded-lg">
                        <?php if ($site_logo): ?>
                            <img src="<?php echo BASE_URL . 'assets/uploads/' . htmlspecialchars($site_logo); ?>" alt="Logo del Municipio" class="h-8 w-auto">
                        <?php else: ?>
                            <i class="fas fa-building text-purple-600 text-2xl"></i>
                        <?php endif; ?>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold"><?php echo htmlspecialchars($site_name); ?></h1>
                        <p class="text-sm opacity-90">Portal del Ciudadano</p>
                    </div>
                </div>
                
                <div class="flex items-center space-x-6">
                    <div class="currency-badge bg-white/20 px-4 py-2 rounded-lg backdrop-blur">
                        <div class="flex items-center space-x-2">
                            <i class="fas fa-chart-line"></i>
                            <?php
                            $usd_rate = $currency->getCurrency('USD')['exchange_rate'] ?? 36.50;
                            $eur_rate = $currency->getCurrency('EUR')['exchange_rate'] ?? 39.80;
                            ?>
                            <span class="text-sm">USD: Bs. <?php echo number_format($usd_rate, 2); ?></span>
                            <span class="text-sm">EUR: Bs. <?php echo number_format($eur_rate, 2); ?></span>
                        </div>
                    </div>
                    
                    <div class="flex space-x-3">
                        <a href="login.php" class="bg-white text-purple-600 px-4 py-2 rounded-lg font-semibold hover:bg-opacity-90 transition">
                            <i class="fas fa-sign-in-alt mr-2"></i>Iniciar Sesión
                        </a>
                        <a href="register.php" class="bg-purple-800 text-white px-4 py-2 rounded-lg font-semibold hover:bg-purple-900 transition">
                            <i class="fas fa-user-plus mr-2"></i>Registrarse
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </header>

    <section class="gradient-bg text-white py-20">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-2 gap-12 items-center">
                <div>
                    <h2 class="text-5xl font-bold mb-6">Tu Alcaldía Digital</h2>
                    <p class="text-xl mb-8 opacity-95">
                        Realiza todos tus trámites municipales desde la comodidad de tu hogar. 
                        Sistema multimoneda adaptado a la economía actual.
                    </p>
                    <div class="flex flex-wrap gap-4">
                        <button onclick="scrollToServices()" class="bg-white text-purple-600 px-6 py-3 rounded-lg font-semibold hover:bg-opacity-90 transition">
                            <i class="fas fa-compass mr-2"></i>Explorar Servicios
                        </button>
                        <button onclick="window.location.href='register.php'" class="bg-purple-800 text-white px-6 py-3 rounded-lg font-semibold hover:bg-purple-900 transition">
                            <i class="fas fa-rocket mr-2"></i>Comenzar Ahora
                        </button>
                    </div>
                    
                    <div class="grid grid-cols-3 gap-4 mt-12">
                        <div class="bg-white/10 backdrop-blur rounded-lg p-4">
                            <div class="text-3xl font-bold">15,234</div>
                            <div class="text-sm opacity-90">Usuarios Activos</div>
                        </div>
                        <div class="bg-white/10 backdrop-blur rounded-lg p-4">
                            <div class="text-3xl font-bold">8,567</div>
                            <div class="text-sm opacity-90">Trámites/Mes</div>
                        </div>
                        <div class="bg-white/10 backdrop-blur rounded-lg p-4">
                            <div class="text-3xl font-bold">99.8%</div>
                            <div class="text-sm opacity-90">Satisfacción</div>
                        </div>
                    </div>
                </div>
                
                <div class="relative">
                    <div class="bg-white rounded-2xl shadow-2xl p-8">
                        <img src="https://placehold.co/600x400/667eea/ffffff?text=Dashboard+Sistema+Municipal" alt="Dashboard del sistema municipal mostrando estadísticas y gestión de trámites" class="rounded-lg w-full">
                    </div>
                    <div class="absolute -bottom-4 -right-4 bg-yellow-400 text-gray-900 rounded-lg px-4 py-2 font-bold shadow-lg">
                        <i class="fas fa-star mr-2"></i>100% Digital
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="services" class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-4xl font-bold text-gray-800 mb-4">Servicios Disponibles</h2>
                <p class="text-xl text-gray-600">Todo lo que necesitas en un solo lugar</p>
            </div>
            
            <div class="grid md:grid-cols-3 lg:grid-cols-4 gap-6">
                <div class="card-hover bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl p-6 text-white shadow-lg cursor-pointer" onclick="window.location.href='login.php'">
                    <div class="bg-white/20 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-file-invoice-dollar text-3xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Impuestos</h3>
                    <p class="opacity-90">Declaración y pago de ISAE, inmuebles, vehículos</p>
                    <div class="mt-4 text-sm opacity-75">
                        <i class="fas fa-clock mr-1"></i> Proceso: 5 min
                    </div>
                </div>
                
                <div class="card-hover bg-gradient-to-br from-green-500 to-green-600 rounded-xl p-6 text-white shadow-lg cursor-pointer" onclick="window.location.href='login.php'">
                    <div class="bg-white/20 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                        <i class="fas fa-map-marked-alt text-3xl"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Catastro</h3>
                    <p class="opacity-90">Cédulas catastrales y actualización de datos</p>
                    <div class="mt-4 text-sm opacity-75">
                        <i class="fas fa-clock mr-1"></i> Proceso: 10 min
                    </div>
                </div>
                
                </div>
        </div>
    </section>

    <footer class="bg-gray-900 text-white py-12">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-4 gap-8">
                <div>
                    <div class="flex items-center space-x-3 mb-4">
                        <div class="bg-purple-600 p-2 rounded">
                            <i class="fas fa-building text-white"></i>
                        </div>
                        <h3 class="text-xl font-bold"><?php echo htmlspecialchars($site_name); ?></h3>
                    </div>
                    <p class="text-gray-400">
                        Tu alcaldía digital, siempre disponible para servirte mejor.
                    </p>
                </div>
                
                </div>
        </div>
    </footer>

    <script>
        function scrollToServices() {
            document.getElementById('services').scrollIntoView({ behavior: 'smooth' });
        }

        function showDemo() {
            alert('Demo interactivo disponible próximamente. Por favor, crea una cuenta para explorar el sistema.');
        }
    </script>
</body>
</html>