<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/LicenseController.php'; // Lo crearemos a continuación

$user = $auth->getUser();
$controller = new LicenseController();
$licenses = $controller->getLicensesByUserId($user['id']);
$eligibleActivities = $controller->getEligibleActivitiesForLicense($user['id']);

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mis Licencias de Actividades Económicas - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4 flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-700">Mis Licencias (Patente)</h2>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                
                <div class="bg-white p-6 rounded-lg shadow-md mb-6">
                    <h3 class="text-lg font-semibold border-b pb-3 mb-4">Solicitar Nueva Licencia</h3>
                    <?php if (empty($eligibleActivities)): ?>
                        <p class="text-gray-500">No tiene actividades económicas activas que requieran una licencia en este momento.</p>
                    <?php else: ?>
                        <form action="actions/license_actions.php" method="POST">
                            <input type="hidden" name="action" value="request_license">
                            <div class="flex items-center space-x-4">
                                <select name="activity_id" class="w-full px-3 py-2 border rounded-lg" required>
                                    <option value="">Seleccione la actividad económica...</option>
                                    <?php foreach ($eligibleActivities as $activity): ?>
                                        <option value="<?php echo $activity['id']; ?>">
                                            <?php echo htmlspecialchars($activity['activity_code'] . ' - ' . $activity['description']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <button type="submit" class="bg-blue-600 text-white px-5 py-2 rounded-lg hover:bg-blue-700 transition whitespace-nowrap">
                                    <i class="fas fa-paper-plane mr-2"></i>Enviar Solicitud
                                </button>
                            </div>
                        </form>
                    <?php endif; ?>
                </div>

                <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="p-3 text-left">Actividad Económica</th>
                                <th class="p-3 text-left">N° de Licencia</th>
                                <th class="p-3 text-center">Estado</th>
                                <th class="p-3 text-left">Fecha de Solicitud</th>
                                <th class="p-3 text-left">Fecha de Vencimiento</th>
                                <th class="p-3 text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($licenses)): ?>
                                <tr><td colspan="6" class="p-4 text-center text-gray-500">No ha solicitado ninguna licencia.</td></tr>
                            <?php else: ?>
                                <?php foreach ($licenses as $license): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm"><?php echo htmlspecialchars($license['activity_description']); ?></td>
                                    <td class="p-3 font-mono text-sm"><?php echo htmlspecialchars($license['license_number'] ?: 'N/A'); ?></td>
                                    <td class="p-3 text-center">
                                        <span class="px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                            <?php echo ucfirst($license['status']); ?>
                                        </span>
                                    </td>
                                    <td class="p-3 text-sm"><?php echo formatDateTime($license['request_date']); ?></td>
                                    <td class="p-3 text-sm"><?php echo $license['expiry_date'] ? formatDate($license['expiry_date']) : 'N/A'; ?></td>
                                    <td class="p-3 text-center">
                                        <?php if ($license['status'] === 'aprobada'): ?>
                                            <a href="#" class="text-blue-500 hover:underline text-sm"><i class="fas fa-download mr-1"></i>Descargar</a>
                                        <?php else: ?>
                                            <span class="text-gray-400 text-xs">—</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>
</html>