<?php
require_once '../config/config.php';

$alert = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $documentNumber = sanitize($_POST['document_number']);
    $password = $_POST['password'];
    
    $result = $auth->login($documentNumber, $password);
    
    if ($result['success']) {
        if ($auth->hasPermission('admin_panel_access')) {
            header('Location: ../admin/index.php');
        } else {
            header('Location: dashboard.php');
        }
        exit;
    } else {
        $alert = ['type' => 'error', 'message' => $result['message']];
    }
}

if ($auth->isLoggedIn()) {
    if ($auth->hasPermission('admin_panel_access')) {
        header('Location: ../admin/index.php');
    } else {
        header('Location: dashboard.php');
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .login-card { backdrop-filter: blur(10px); background: rgba(255, 255, 255, 0.1); border: 1px solid rgba(255, 255, 255, 0.2); }
        .input-focus:focus { box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.3); }
    </style>
</head>
<body class="gradient-bg min-h-screen flex items-center justify-center p-4">
    <div class="container max-w-6xl mx-auto">
        <div class="text-center mb-8">
            <div class="inline-flex items-center space-x-3 bg-white/20 backdrop-blur rounded-full px-6 py-3 mb-4">
                <i class="fas fa-building text-white text-2xl"></i>
                <h1 class="text-2xl font-bold text-white">Sistema Municipal</h1>
            </div>
            <p class="text-white/90">Portal del Ciudadano - Iniciar Sesión</p>
        </div>
        <div class="grid md:grid-cols-2 gap-8 items-center">
            <div class="login-card rounded-2xl p-8 shadow-2xl">
                <h2 class="text-3xl font-bold text-white mb-6">Bienvenido de Nuevo</h2>
                
                <?php if ($alert): ?>
                <div class="p-4 rounded-lg mb-6 bg-red-500/20 text-red-300 border border-red-400/30">
                    <div class="flex items-center"><i class="fas fa-exclamation-circle mr-3"></i><span><?php echo $alert['message']; ?></span></div>
                </div>
                <?php endif; ?>
                <?php if ($alert = getAlert()): ?>
                <div class="p-4 rounded-lg mb-6 bg-green-500/20 text-green-300 border border-green-400/30">
                    <div class="flex items-center"><i class="fas fa-check-circle mr-3"></i><span><?php echo $alert['message']; ?></span></div>
                </div>
                <?php endif; ?>

                <form method="POST" class="space-y-6">
                    <div>
                        <label class="block text-white mb-2 font-medium">Número de Documento</label>
                        <input type="text" name="document_number" value="<?php echo $_POST['document_number'] ?? ''; ?>" class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus" placeholder="Ej: V12345678" required>
                    </div>
                    <div>
                        <label class="block text-white mb-2 font-medium">Contraseña</label>
                        <input type="password" name="password" id="password" class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus pr-12" placeholder="Ingresa tu contraseña" required>
                    </div>
                    <div class="flex justify-between items-center">
                        <label class="flex items-center text-white"><input type="checkbox" name="remember" class="mr-2 rounded bg-white/20">Recordar sesión</label>
                        <a href="#" class="text-white/80 hover:text-white text-sm">¿Olvidaste tu contraseña?</a>
                    </div>
                    <button type="submit" class="w-full bg-white text-purple-600 py-3 rounded-lg font-semibold hover:bg-opacity-90 transition">
                        <i class="fas fa-sign-in-alt mr-2"></i>Iniciar Sesión
                    </button>
                </form>
                <div class="text-center mt-6">
                    <p class="text-white/80">¿No tienes cuenta? <a href="register.php" class="text-white font-semibold hover:underline">Regístrate aquí</a></p>
                </div>
            </div>
            <div class="hidden md:block space-y-6">
                <div class="bg-white/10 backdrop-blur rounded-xl p-6">
                    <div class="flex items-center space-x-3 mb-4">
                        <div class="bg-green-400 text-green-900 w-12 h-12 rounded-full flex items-center justify-center"><i class="fas fa-shield-alt"></i></div>
                        <h3 class="text-xl font-bold text-white">Seguridad Garantizada</h3>
                    </div>
                    <ul class="text-white/90 space-y-2">
                        <li><i class="fas fa-check-circle text-green-400 mr-2"></i>Encriptación SSL 256-bit</li>
                        <li><i class="fas fa-check-circle text-green-400 mr-2"></i>Protección de Datos</li>
                    </ul>
                </div>
                <div class="bg-white/10 backdrop-blur rounded-xl p-6">
                    <h3 class="text-xl font-bold text-white mb-4">Acceso Rápido</h3>
                    <div class="grid grid-cols-2 gap-3">
                        <a href="#" class="bg-purple-600 text-white py-2 px-3 rounded-lg text-sm hover:bg-purple-700 transition text-center"><i class="fas fa-list mr-1"></i>Servicios</a>
                        <a href="#" class="bg-blue-600 text-white py-2 px-3 rounded-lg text-sm hover:bg-blue-700 transition text-center"><i class="fas fa-question-circle mr-1"></i>Ayuda</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt-12">
            <p class="text-white/60 text-sm">© <?php echo date('Y'); ?> Sistema Municipal. Todos los derechos reservados.</p>
        </div>
    </div>
</body>
</html>