<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/CitizenTaxController.php'; // Reutilizamos este controlador por ahora

$user = $auth->getUser();
$controller = new CitizenTaxController();
$activities = $controller->getEconomicActivitiesByUserId($user['id']); // Usamos una nueva función que añadiremos
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mis Actividades Económicas - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4 flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-700">Mis Actividades Económicas</h2>
                <a href="registrar-actividad.php" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition">
                    <i class="fas fa-plus mr-2"></i>Registrar Nueva Actividad
                </a>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="p-3 text-left">Código</th>
                                <th class="p-3 text-left">Descripción</th>
                                <th class="p-3 text-center">Estado</th>
                                <th class="p-3 text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($activities)): ?>
                                <tr><td colspan="4" class="p-4 text-center text-gray-500">No ha registrado ninguna actividad económica.</td></tr>
                            <?php else: ?>
                                <?php foreach ($activities as $activity): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 font-mono"><?php echo htmlspecialchars($activity['activity_code']); ?></td>
                                    <td class="p-3"><?php echo htmlspecialchars($activity['description']); ?></td>
                                    <td class="p-3 text-center">
                                        <?php
                                            $statusText = ''; $statusColor = '';
                                            switch ($activity['status']) {
                                                case 'pending_verification': $statusText = 'Pendiente'; $statusColor = 'bg-yellow-100 text-yellow-800'; break;
                                                case 'active': $statusText = 'Activa'; $statusColor = 'bg-green-100 text-green-800'; break;
                                                case 'rejected': $statusText = 'Rechazada'; $statusColor = 'bg-red-100 text-red-800'; break;
                                                case 'inactive': $statusText = 'Inactiva'; $statusColor = 'bg-gray-100 text-gray-800'; break;
                                            }
                                        ?>
                                        <span class="px-3 py-1 text-sm font-semibold rounded-full <?php echo $statusColor; ?>"><?php echo $statusText; ?></span>
                                        <?php if ($activity['status'] === 'rejected' && !empty($activity['rejection_reason'])): ?>
                                            <p class="text-xs text-gray-600 mt-1"><strong>Motivo:</strong> <?php echo htmlspecialchars($activity['rejection_reason']); ?></p>
                                        <?php endif; ?>
                                    </td>
                                    <td class="p-3 text-center">
                                        <?php if ($activity['status'] === 'active'): ?>
                                            <a href="declarar-isae.php?activity_id=<?php echo $activity['id']; ?>" class="bg-blue-500 text-white px-3 py-1 text-xs rounded-md hover:bg-blue-600">
                                                Declarar Ingresos
                                            </a>
                                        <?php elseif ($activity['status'] === 'rejected'): ?>
                                             <a href="registrar-actividad.php?edit_id=<?php echo $activity['id']; ?>" class="bg-orange-500 text-white px-3 py-1 text-xs rounded-md hover:bg-orange-600">
                                                Corregir
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>
</html>