<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/CitizenTaxController.php';

$user = $auth->getUser();
$controller = new CitizenTaxController();
$taxes = $controller->getTaxesByUserId($user['id']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mis Impuestos - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4 flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-700">Mis Impuestos y Estado de Cuenta</h2>
                <span class="text-gray-600 font-bold">
                    <?php echo htmlspecialchars($user['user_type'] === 'natural' ? $user['first_name'] . ' ' . $user['last_name'] : $user['company_name']); ?>
                </span>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-3">Declarar o Pagar Impuestos</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        <a href="declarar-vehiculo.php" class="bg-blue-500 text-white p-4 rounded-lg shadow hover:bg-blue-600 transition text-center">
                            <i class="fas fa-car text-2xl mb-2"></i>
                            <p class="font-semibold">Impuesto Vehicular</p>
                        </a>
                        <a href="mis-actividades.php" class="bg-green-500 text-white p-4 rounded-lg shadow hover:bg-green-600 transition text-center">
                            <i class="fas fa-store text-2xl mb-2"></i>
                            <p class="font-semibold">Actividades Económicas</p>
                        </a>
                        <a href="mis-anuncios.php" class="bg-orange-500 text-white p-4 rounded-lg shadow hover:bg-orange-600 transition text-center">
                            <i class="fas fa-ad text-2xl mb-2"></i>
                            <p class="font-semibold">Publicidad y Propaganda</p>
                        </a>
                    </div>
                </div>

                <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="p-3 text-left text-sm font-semibold text-gray-600">Concepto</th>
                                <th class="p-3 text-left text-sm font-semibold text-gray-600">Monto</th>
                                <th class="p-3 text-left text-sm font-semibold text-gray-600">Fecha de Vencimiento</th>
                                <th class="p-3 text-center text-sm font-semibold text-gray-600">Estado</th>
                                <th class="p-3 text-center text-sm font-semibold text-gray-600">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($taxes)): ?>
                                <tr><td colspan="5" class="p-4 text-center text-gray-500">No tiene deudas pendientes ni historial de pagos.</td></tr>
                            <?php else: ?>
                                <?php foreach ($taxes as $tax): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm text-gray-800 font-medium"><?php echo htmlspecialchars($tax['tax_type']); ?></td>
                                    <td class="p-3 text-sm text-gray-700 font-mono"><?php echo htmlspecialchars($tax['currency_symbol']) . ' ' . number_format($tax['amount'], 2); ?></td>
                                    <td class="p-3 text-sm text-gray-700"><?php echo formatDate($tax['due_date']); ?></td>
                                    <td class="p-3 text-center">
                                        <span class="px-2 py-1 rounded-full text-xs font-semibold <?php 
                                            switch($tax['status']) {
                                                case 'paid': echo 'bg-green-100 text-green-700'; break;
                                                case 'pending': echo 'bg-yellow-100 text-yellow-700'; break;
                                                case 'overdue': echo 'bg-red-100 text-red-700'; break;
                                                case 'in_verification': echo 'bg-blue-100 text-blue-700'; break;
                                                default: echo 'bg-gray-200 text-gray-700';
                                            }
                                        ?>"><?php echo ucfirst(str_replace('_', ' ', $tax['status'])); ?></span>
                                    </td>
                                    <td class="p-3 text-center">
                                        <?php if ($tax['status'] === 'pending' || $tax['status'] === 'overdue'): ?>
                                            <a href="reportar-pago.php?tax_id=<?php echo $tax['id']; ?>" class="bg-green-600 text-white px-3 py-1 rounded-md text-xs font-semibold hover:bg-green-700">Pagar</a>
                                        <?php elseif ($tax['status'] === 'paid'): ?>
                                            <a href="#" class="text-blue-600 text-xs font-semibold">Ver Recibo</a>
                                        <?php else: ?>
                                            <span class="text-gray-500 text-xs">En Proceso</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>
</html>