<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/PropertyController.php';

$user = $auth->getUser();
$controller = new PropertyController();
$properties = $controller->getPropertiesByUserId($user['id']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mis Inmuebles - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4 flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-700">Mis Inmuebles Registrados</h2>
                <a href="registrar-inmueble.php" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition">
                    <i class="fas fa-plus mr-2"></i>Registrar Nuevo Inmueble
                </a>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="p-3 text-left">Cédula Catastral</th>
                                <th class="p-3 text-left">Dirección</th>
                                <th class="p-3 text-left">Tipo</th>
                                <th class="p-3 text-center">Estado</th>
                                <th class="p-3 text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($properties)): ?>
                                <tr><td colspan="5" class="p-4 text-center text-gray-500">No ha registrado ningún inmueble.</td></tr>
                            <?php else: ?>
                                <?php foreach ($properties as $property): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 font-mono"><?php echo htmlspecialchars($property['cadastral_code']); ?></td>
                                    <td class="p-3"><?php echo htmlspecialchars($property['address']); ?></td>
                                    <td class="p-3"><?php echo htmlspecialchars($property['property_type']); ?></td>
                                    <td class="p-3 text-center">
                                         <?php
                                            $statusText = ''; $statusColor = '';
                                            switch ($property['status']) {
                                                case 'pending_verification': $statusText = 'Pendiente'; $statusColor = 'bg-yellow-100 text-yellow-800'; break;
                                                case 'verified': $statusText = 'Verificado'; $statusColor = 'bg-green-100 text-green-800'; break;
                                                case 'rejected': $statusText = 'Rechazado'; $statusColor = 'bg-red-100 text-red-800'; break;
                                            }
                                        ?>
                                        <span class="px-3 py-1 text-sm font-semibold rounded-full <?php echo $statusColor; ?>"><?php echo $statusText; ?></span>
                                        <?php if ($property['status'] === 'rejected' && !empty($property['rejection_reason'])): ?>
                                            <p class="text-xs text-gray-600 mt-1"><strong>Motivo:</strong> <?php echo htmlspecialchars($property['rejection_reason']); ?></p>
                                        <?php endif; ?>
                                    </td>
                                    <td class="p-3 text-center">
                                        <?php if ($property['status'] === 'rejected'): ?>
                                            <a href="#" class="bg-orange-500 text-white px-3 py-1 text-xs rounded-md hover:bg-orange-600">Corregir</a>
                                        <?php else: ?>
                                             <span class="text-gray-400 text-xs">—</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>
</html>