<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/PermitController.php';

$user = $auth->getUser();
$controller = new PermitController();
$permits = $controller->getPermitsByUserId($user['id']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mis Permisos y Licencias - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4 flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-700">Mis Permisos y Licencias</h2>
                <div class="space-x-2">
                    <a href="solicitar-permiso-construccion.php" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition text-sm">
                        <i class="fas fa-hard-hat mr-2"></i>Permiso de Construcción
                    </a>
                    <a href="solicitar-permiso-evento.php" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition text-sm">
                        <i class="fas fa-calendar-check mr-2"></i>Permiso de Eventos
                    </a>
                </div>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="bg-white rounded-lg shadow-md overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="p-3 text-left">Tipo de Permiso</th>
                                <th class="p-3 text-left">N° de Permiso</th>
                                <th class="p-3 text-center">Estado</th>
                                <th class="p-3 text-left">Fecha de Solicitud</th>
                                <th class="p-3 text-left">Fecha de Vencimiento</th>
                                <th class="p-3 text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($permits)): ?>
                                <tr><td colspan="6" class="p-4 text-center text-gray-500">No ha solicitado ningún permiso.</td></tr>
                            <?php else: ?>
                                <?php foreach ($permits as $permit): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="p-3 text-sm font-medium"><?php echo htmlspecialchars($permit['permit_name']); ?></td>
                                    <td class="p-3 font-mono text-sm"><?php echo htmlspecialchars($permit['permit_number'] ?: 'En Proceso'); ?></td>
                                    <td class="p-3 text-center">
                                        <span class="px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                            <?php echo ucfirst(str_replace('_', ' ', $permit['status'])); ?>
                                        </span>
                                    </td>
                                    <td class="p-3 text-sm"><?php echo formatDateTime($permit['application_date']); ?></td>
                                    <td class="p-3 text-sm"><?php echo $permit['expiry_date'] ? formatDate($permit['expiry_date']) : 'N/A'; ?></td>
                                    <td class="p-3 text-center">
                                        <a href="#" class="text-gray-400 text-xs">—</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>
</html>