<?php
// public/register.php
require_once '../config/config.php';

$alert = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'user_type' => sanitize($_POST['user_type']),
        'document_type' => sanitize($_POST['document_type']),
        'document_number' => sanitize($_POST['document_number']),
        'email' => sanitize($_POST['email']),
        'password' => $_POST['password'],
        'confirm_password' => $_POST['confirm_password'],
        'first_name' => sanitize($_POST['first_name']),
        'last_name' => sanitize($_POST['last_name']),
        'company_name' => sanitize($_POST['company_name']),
        'phone' => sanitize($_POST['phone']),
        'address' => sanitize($_POST['address'])
    ];
    
    // Validar que las contraseñas coincidan
    if ($data['password'] !== $data['confirm_password']) {
        $alert = ['type' => 'error', 'message' => 'Las contraseñas no coinciden'];
    } else {
        $result = $auth->register($data);
        
        if ($result['success']) {
            setAlert('¡Registro exitoso! Por favor inicie sesión.', 'success');
            header('Location: login.php');
            exit;
        } else {
            $alert = ['type' => 'error', 'message' => $result['message']];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .register-card {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        .input-focus:focus {
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.3);
        }
        .tab-active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
    </style>
</head>
<body class="gradient-bg min-h-screen flex items-center justify-center p-4">
    <div class="container max-w-4xl mx-auto">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center space-x-3 bg-white/20 backdrop-blur rounded-full px-6 py-3 mb-4">
                <i class="fas fa-building text-white text-2xl"></i>
                <h1 class="text-2xl font-bold text-white">Sistema Municipal</h1>
            </div>
            <p class="text-white/90">Portal del Ciudadano - Crear Cuenta</p>
        </div>

        <div class="register-card rounded-2xl p-8 shadow-2xl">
            <!-- Alert Message -->
            <?php if ($alert): ?>
            <div class="p-4 rounded-lg mb-6 <?php echo $alert['type'] === 'error' ? 'bg-red-500/20 text-red-300 border border-red-400/30' : 'bg-green-500/20 text-green-300 border border-green-400/30' ?>">
                <div class="flex items-center">
                    <i class="fas <?php echo $alert['type'] === 'error' ? 'fa-exclamation-circle' : 'fa-check-circle' ?> mr-3"></i>
                    <span><?php echo $alert['message']; ?></span>
                </div>
            </div>
            <?php endif; ?>

            <!-- User Type Tabs -->
            <div class="flex bg-white/10 rounded-lg p-1 mb-6">
                <button type="button" onclick="setUserType('natural')" 
                        class="flex-1 py-2 px-4 rounded-lg transition user-type-tab <?php echo (!isset($_POST['user_type']) || $_POST['user_type'] === 'natural') ? 'tab-active' : 'text-white/80 hover:text-white' ?>">
                    <i class="fas fa-user mr-2"></i>Persona Natural
                </button>
                <button type="button" onclick="setUserType('juridica')" 
                        class="flex-1 py-2 px-4 rounded-lg transition user-type-tab <?php echo (isset($_POST['user_type']) && $_POST['user_type'] === 'juridica') ? 'tab-active' : 'text-white/80 hover:text-white' ?>">
                    <i class="fas fa-building mr-2"></i>Persona Jurídica
                </button>
            </div>

            <form id="registerForm" method="POST" class="space-y-6">
                <input type="hidden" name="user_type" id="user_type" value="<?php echo $_POST['user_type'] ?? 'natural'; ?>">
                
                <!-- Document Information -->
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-white mb-2 font-medium">Tipo de Documento</label>
                        <select name="document_type" class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white input-focus" required>
                            <option value="">Seleccionar...</option>
                            <option value="cedula" <?php echo ($_POST['document_type'] ?? '') === 'cedula' ? 'selected' : ''; ?>>Cédula</option>
                            <option value="rif" <?php echo ($_POST['document_type'] ?? '') === 'rif' ? 'selected' : ''; ?>>RIF</option>
                            <option value="passport" <?php echo ($_POST['document_type'] ?? '') === 'passport' ? 'selected' : ''; ?>>Pasaporte</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-white mb-2 font-medium">Número de Documento</label>
                        <input type="text" name="document_number" 
                               value="<?php echo $_POST['document_number'] ?? ''; ?>"
                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus"
                               placeholder="Ej: V12345678" required>
                    </div>
                </div>

                <!-- Personal Information (for natural persons) -->
                <div id="naturalFields" class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-white mb-2 font-medium">Nombres</label>
                        <input type="text" name="first_name" 
                               value="<?php echo $_POST['first_name'] ?? ''; ?>"
                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus"
                               placeholder="Ingrese sus nombres">
                    </div>

                    <div>
                        <label class="block text-white mb-2 font-medium">Apellidos</label>
                        <input type="text" name="last_name" 
                               value="<?php echo $_POST['last_name'] ?? ''; ?>"
                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus"
                               placeholder="Ingrese sus apellidos">
                    </div>
                </div>

                <!-- Company Information (for juridical persons) -->
                <div id="juridicaFields" class="hidden">
                    <div>
                        <label class="block text-white mb-2 font-medium">Nombre de la Empresa</label>
                        <input type="text" name="company_name" 
                               value="<?php echo $_POST['company_name'] ?? ''; ?>"
                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus"
                               placeholder="Ingrese el nombre de la empresa">
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-white mb-2 font-medium">Email</label>
                        <input type="email" name="email" 
                               value="<?php echo $_POST['email'] ?? ''; ?>"
                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus"
                               placeholder="ejemplo@correo.com" required>
                    </div>

                    <div>
                        <label class="block text-white mb-2 font-medium">Teléfono</label>
                        <input type="tel" name="phone" 
                               value="<?php echo $_POST['phone'] ?? ''; ?>"
                               class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus"
                               placeholder="+58 412-1234567">
                    </div>
                </div>

                <div>
                    <label class="block text-white mb-2 font-medium">Dirección</label>
                    <textarea name="address" rows="2"
                              class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus resize-none"
                              placeholder="Ingrese su dirección completa"><?php echo $_POST['address'] ?? ''; ?></textarea>
                </div>

                <!-- Password -->
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-white mb-2 font-medium">Contraseña</label>
                        <div class="relative">
                            <input type="password" name="password" id="password"
                                   class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus pr-12"
                                   placeholder="Mínimo 8 caracteres" required minlength="8">
                            <button type="button" onclick="togglePassword('password')" class="absolute right-3 top-3 text-white/60 hover:text-white">
                                <i class="fas fa-eye" id="password-icon"></i>
                            </button>
                        </div>
                    </div>

                    <div>
                        <label class="block text-white mb-2 font-medium">Confirmar Contraseña</label>
                        <div class="relative">
                            <input type="password" name="confirm_password" id="confirm_password"
                                   class="w-full px-4 py-3 rounded-lg bg-white/10 border border-white/20 text-white placeholder-white/60 input-focus pr-12"
                                   placeholder="Repita su contraseña" required>
                            <button type="button" onclick="togglePassword('confirm_password')" class="absolute right-3 top-3 text-white/60 hover:text-white">
                                <i class="fas fa-eye" id="confirm-password-icon"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Terms and Conditions -->
                <div class="flex items-center">
                    <input type="checkbox" name="terms" id="terms" class="mr-2 rounded bg-white/20" required>
                    <label for="terms" class="text-white text-sm">
                        Acepto los <a href="#" class="text-white underline hover:no-underline">términos y condiciones</a> y 
                        <a href="#" class="text-white underline hover:no-underline">políticas de privacidad</a>
                    </label>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="w-full bg-white text-purple-600 py-3 rounded-lg font-semibold hover:bg-opacity-90 transition">
                    <i class="fas fa-user-plus mr-2"></i>Crear Cuenta
                </button>
            </form>

            <!-- Login Link -->
            <div class="text-center mt-6">
                <p class="text-white/80">
                    ¿Ya tienes cuenta? 
                    <a href="login.php" class="text-white font-semibold hover:underline">
                        Inicia sesión aquí
                    </a>
                </p>
            </div>
        </div>

        <!-- Footer -->
        <div class="text-center mt-12">
            <p class="text-white/60 text-sm">
                © 2024 Sistema Municipal. Todos los derechos reservados.
            </p>
        </div>
    </div>

    <script>
        // Set user type and show/hide fields
        function setUserType(type) {
            document.getElementById('user_type').value = type;
            
            // Update tab styles
            document.querySelectorAll('.user-type-tab').forEach(tab => {
                tab.classList.remove('tab-active');
                tab.classList.add('text-white/80', 'hover:text-white');
            });
            
            event.target.classList.add('tab-active');
            event.target.classList.remove('text-white/80', 'hover:text-white');
            
            // Show/hide fields based on user type
            if (type === 'natural') {
                document.getElementById('naturalFields').classList.remove('hidden');
                document.getElementById('juridicaFields').classList.add('hidden');
            } else {
                document.getElementById('naturalFields').classList.add('hidden');
                document.getElementById('juridicaFields').classList.remove('hidden');
            }
        }

        // Toggle password visibility
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const icon = document.getElementById(fieldId + '-icon');
            
            if (field.type === 'password') {
                field.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                field.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }

        // Document type specific formatting
        document.querySelector('select[name="document_type"]').addEventListener('change', function() {
            const input = document.querySelector('input[name="document_number"]');
            const type = this.value;
            
            switch(type) {
                case 'cedula':
                    input.placeholder = 'Ej: V12345678';
                    break;
                case 'rif':
                    input.placeholder = 'Ej: J-123456789';
                    break;
                case 'passport':
                    input.placeholder = 'Ej: AB123456';
                    break;
                default:
                    input.placeholder = 'Número de documento';
            }
        });

        // Initialize based on current user type
        <?php if (isset($_POST['user_type'])): ?>
        setUserType('<?php echo $_POST['user_type']; ?>');
        <?php endif; ?>

        // Form validation
        document.getElementById('registerForm').addEventListener('submit', function(e) {
            const password = document.getElementById('password').value;
            const confirmPassword = document.getElementById('confirm_password').value;
            const terms = document.getElementById('terms').checked;
            
            if (password !== confirmPassword) {
                e.preventDefault();
                alert('Las contraseñas no coinciden');
                return false;
            }
            
            if (!terms) {
                e.preventDefault();
                alert('Debe aceptar los términos y condiciones');
                return false;
            }
        });
    </script>
</body>
</html>
