<?php
require_once '../config/config.php';
requireAuth();
$user = $auth->getUser();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Actividad Económica - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4">
                <h2 class="text-xl font-semibold text-gray-700">Registro de Actividad Económica</h2>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    <form action="actions/activity_actions.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="register_activity">
                        <div class="border-b pb-4 mb-6">
                            <h3 class="text-lg font-semibold text-gray-800">Datos de la Actividad</h3>
                            <p class="text-sm text-gray-500">Introduzca la información y adjunte los documentos requeridos para su aprobación.</p>
                        </div>
                        <div class="space-y-6">
                            <div>
                                <label for="activity_code" class="block text-sm font-medium text-gray-700 mb-2">Código Clasificador de Actividad</label>
                                <input type="text" name="activity_code" id="activity_code" class="w-full px-3 py-2 border border-gray-300 rounded-lg" placeholder="Ej: 6201.01" required>
                            </div>
                            <div>
                                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Descripción de la Actividad</label>
                                <textarea name="description" id="description" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg" placeholder="Ej: Venta al por menor de equipos de informática" required></textarea>
                            </div>
                            <div>
                                <label for="documento_actividad" class="block text-sm font-medium text-gray-700 mb-2">Documento de Soporte (RIF, Registro Mercantil, etc.)</label>
                                <input type="file" name="documento_actividad" id="documento_actividad" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0" required>
                            </div>
                        </div>
                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-actividades.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-paper-plane mr-2"></i>Enviar para Revisión
                            </button>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>