<?php
require_once '../config/config.php';
requireAuth();
$user = $auth->getUser();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Publicidad - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4"><h2 class="text-xl font-semibold">Registro de Publicidad y Propaganda</h2></header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-3xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    <form action="actions/advertisement_actions.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="register_ad">
                        <div class="border-b pb-4 mb-6">
                            <h3 class="text-lg font-semibold">Datos del Anuncio</h3>
                            <p class="text-sm text-gray-500">Introduzca los detalles y adjunte una foto o permiso.</p>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="ad_type" class="block text-sm font-medium mb-2">Tipo de Anuncio</label>
                                <select name="ad_type" id="ad_type" class="w-full px-3 py-2 border rounded-lg" required>
                                    <option value="Valla Publicitaria">Valla Publicitaria</option>
                                    <option value="Aviso Luminoso">Aviso Luminoso</option>
                                    <option value="Pendón">Pendón</option>
                                    <option value="Mural">Mural</option>
                                    <option value="Otro">Otro</option>
                                </select>
                            </div>
                             <div>
                                <label for="dimensions" class="block text-sm font-medium mb-2">Dimensiones (ej: 5m x 3m)</label>
                                <input type="text" name="dimensions" id="dimensions" class="w-full px-3 py-2 border rounded-lg" required>
                            </div>
                            <div class="md:col-span-2">
                                <label for="location" class="block text-sm font-medium mb-2">Ubicación Exacta</label>
                                <input type="text" name="location" id="location" class="w-full px-3 py-2 border rounded-lg" required>
                            </div>
                            <div class="md:col-span-2">
                                <label for="description" class="block text-sm font-medium mb-2">Texto o Descripción del Anuncio</label>
                                <textarea name="description" id="description" rows="3" class="w-full px-3 py-2 border rounded-lg" required></textarea>
                            </div>
                            <div>
                                <label for="documento_anuncio" class="block text-sm font-medium mb-2">Foto o Permiso</label>
                                <input type="file" name="documento_anuncio" id="documento_anuncio" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0" required>
                            </div>
                        </div>
                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-anuncios.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-paper-plane mr-2"></i>Enviar para Revisión
                            </button>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>