<?php
require_once '../config/config.php';
requireAuth();
$user = $auth->getUser();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Inmueble - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4"><h2 class="text-xl font-semibold">Registro de Inmueble</h2></header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-3xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    <form action="actions/property_actions.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="register_property">
                        <div class="border-b pb-4 mb-6">
                            <h3 class="text-lg font-semibold">Datos del Inmueble</h3>
                            <p class="text-sm text-gray-500">Introduzca la información y adjunte los documentos requeridos.</p>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="cadastral_code" class="block text-sm font-medium mb-2">Cédula Catastral</label>
                                <input type="text" name="cadastral_code" id="cadastral_code" class="w-full px-3 py-2 border rounded-lg" required>
                            </div>
                            <div>
                                <label for="property_type" class="block text-sm font-medium mb-2">Tipo de Inmueble</label>
                                <select name="property_type" id="property_type" class="w-full px-3 py-2 border rounded-lg" required>
                                    <option value="Casa">Casa</option>
                                    <option value="Apartamento">Apartamento</option>
                                    <option value="Local Comercial">Local Comercial</option>
                                    <option value="Terreno">Terreno</option>
                                    <option value="Oficina">Oficina</option>
                                </select>
                            </div>
                            <div class="md:col-span-2">
                                <label for="address" class="block text-sm font-medium mb-2">Dirección Completa</label>
                                <textarea name="address" id="address" rows="3" class="w-full px-3 py-2 border rounded-lg" required></textarea>
                            </div>
                             <div>
                                <label for="area_m2" class="block text-sm font-medium mb-2">Área (m²)</label>
                                <input type="number" step="0.01" name="area_m2" id="area_m2" class="w-full px-3 py-2 border rounded-lg" required>
                            </div>
                            <div>
                                <label for="documento_inmueble" class="block text-sm font-medium mb-2">Documento de Propiedad</label>
                                <input type="file" name="documento_inmueble" id="documento_inmueble" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0" required>
                            </div>
                        </div>
                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-inmuebles.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-paper-plane mr-2"></i>Enviar para Revisión
                            </button>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>