<?php
require_once '../config/config.php';
requireAuth();

$user = $auth->getUser();
$tax_id = filter_input(INPUT_GET, 'tax_id', FILTER_VALIDATE_INT);

if (!$tax_id) {
    setAlert('ID de impuesto inválido.', 'error');
    header('Location: mis-impuestos.php');
    exit;
}

// Obtener los detalles del impuesto para mostrarlos
$db = Database::getInstance();
$stmt = $db->query(
    "SELECT t.id, t.amount, tc.name, c.symbol 
     FROM taxes t 
     JOIN tax_concepts tc ON t.tax_concept_id = tc.id
     JOIN currencies c ON t.currency_id = c.id
     WHERE t.id = ? AND t.user_id = ?", 
    [$tax_id, $user['id']]
);
$tax = $stmt->fetch();

if (!$tax) {
    setAlert('El impuesto solicitado no fue encontrado o no le pertenece.', 'error');
    header('Location: mis-impuestos.php');
    exit;
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reportar Pago - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4">
                <h2 class="text-xl font-semibold text-gray-700">Reportar Pago de Impuesto</h2>
            </header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    
                    <div class="bg-yellow-50 border border-yellow-200 p-4 rounded-lg mb-6">
                        <h3 class="font-bold text-gray-800">Resumen de la Deuda</h3>
                        <p class="text-gray-600"><strong>Concepto:</strong> <?php echo htmlspecialchars($tax['name']); ?></p>
                        <p class="text-2xl font-bold text-gray-800 mt-2">
                            Monto a Pagar: <?php echo htmlspecialchars($tax['symbol']) . ' ' . number_format($tax['amount'], 2); ?>
                        </p>
                    </div>

                    <form action="actions/payment_actions.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="report_payment">
                        <input type="hidden" name="tax_id" value="<?php echo $tax['id']; ?>">
                        <input type="hidden" name="amount" value="<?php echo $tax['amount']; ?>">
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="payment_method" class="block text-sm font-medium text-gray-700 mb-2">Método de Pago</label>
                                <select name="payment_method" id="payment_method" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                                    <option value="transferencia">Transferencia Bancaria</option>
                                    <option value="pago_movil">Pago Móvil</option>
                                    <option value="deposito">Depósito</option>
                                </select>
                            </div>
                            <div>
                                <label for="bank_name" class="block text-sm font-medium text-gray-700 mb-2">Banco Origen</label>
                                <input type="text" name="bank_name" id="bank_name" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                            </div>
                            <div>
                                <label for="reference_number" class="block text-sm font-medium text-gray-700 mb-2">Número de Referencia</label>
                                <input type="text" name="reference_number" id="reference_number" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                            </div>
                             <div>
                                <label for="payment_date" class="block text-sm font-medium text-gray-700 mb-2">Fecha del Pago</label>
                                <input type="date" name="payment_date" id="payment_date" class="w-full px-3 py-2 border border-gray-300 rounded-lg" required>
                            </div>
                            <div class="md:col-span-2">
                                <label for="receipt" class="block text-sm font-medium text-gray-700 mb-2">Comprobante (Opcional)</label>
                                <input type="file" name="receipt" id="receipt" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                            </div>
                        </div>

                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-impuestos.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-300 transition mr-3">Cancelar</a>
                            <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition flex items-center">
                                <i class="fas fa-paper-plane mr-2"></i>
                                Notificar Pago
                            </button>
                        </div>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>