<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/PermitController.php';

$user = $auth->getUser();
$controller = new PermitController();
$permitTypes = $controller->getConstructionPermitTypes();
$properties = $controller->getVerifiedPropertiesByUserId($user['id']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitar Permiso de Construcción - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>
        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4"><h2 class="text-xl font-semibold">Solicitar Permiso de Construcción / Urbanismo</h2></header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-3xl mx-auto bg-white p-8 rounded-lg shadow-md">
                    <form action="actions/permit_actions.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="request_construction_permit">
                        
                        <?php if (empty($properties)): ?>
                            <div class="p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50" role="alert">
                                <span class="font-medium">¡Atención!</span> Para solicitar un permiso de construcción, primero debe tener al menos un inmueble registrado y verificado por la alcaldía.
                                <a href="mis-inmuebles.php" class="font-bold hover:underline">Vaya a Mis Inmuebles para comenzar.</a>
                            </div>
                        <?php else: ?>

                        <div class="space-y-6">
                            <div>
                                <label for="permit_type_id" class="block text-sm font-medium mb-2">Tipo de Permiso</label>
                                <select name="permit_type_id" id="permit_type_id" class="w-full px-3 py-2 border rounded-lg" required>
                                    <option value="">Seleccione un tipo de permiso...</option>
                                    <?php foreach ($permitTypes as $type): ?>
                                        <option value="<?php echo $type['id']; ?>"><?php echo htmlspecialchars($type['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                             <div>
                                <label for="property_id" class="block text-sm font-medium mb-2">Inmueble Asociado</label>
                                <select name="property_id" id="property_id" class="w-full px-3 py-2 border rounded-lg" required>
                                    <option value="">Seleccione el inmueble...</option>
                                    <?php foreach ($properties as $property): ?>
                                        <option value="<?php echo $property['id']; ?>"><?php echo htmlspecialchars($property['cadastral_code'] . ' - ' . $property['address']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div>
                                <label for="notes" class="block text-sm font-medium mb-2">Notas Adicionales (Opcional)</label>
                                <textarea name="notes" id="notes" rows="4" class="w-full px-3 py-2 border rounded-lg" placeholder="Añada cualquier información relevante para su solicitud."></textarea>
                            </div>
                            <div>
                                <label for="document_support" class="block text-sm font-medium mb-2">Planos y Documentos de Soporte (PDF, JPG, PNG)</label>
                                <input type="file" name="document_support" id="document_support" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0" required>
                            </div>
                        </div>
                        <div class="mt-8 pt-6 border-t flex justify-end">
                            <a href="mis-permisos.php" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-lg mr-3">Cancelar</a>
                            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center">
                                <i class="fas fa-paper-plane mr-2"></i>Enviar Solicitud
                            </button>
                        </div>

                        <?php endif; ?>
                    </form>
                </div>
            </main>
        </div>
    </div>
</body>
</html>