<?php
require_once '../config/config.php';
requireAuth();
require_once 'controllers/SolvencyController.php';

$user = $auth->getUser();
$controller = new SolvencyController();

$solvencyStatus = $controller->checkSolvencyStatus($user['id']);
$solvencyHistory = $controller->getSolvencyHistory($user['id']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Solvencias - Sistema Municipal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        <?php include 'partials/citizen_sidebar.php'; ?>

        <div class="flex-1 flex flex-col">
            <header class="bg-white shadow-md p-4"><h2 class="text-xl font-semibold text-gray-700">Gestión de Solvencias</h2></header>
            <main class="flex-1 p-6 overflow-y-auto">
                <div class="max-w-4xl mx-auto">

                    <div class="bg-white p-6 rounded-lg shadow-md mb-6">
                        <h3 class="text-lg font-semibold border-b pb-3 mb-4">Estado Actual y Emisión de Solvencia</h3>
                        <?php if ($solvencyStatus['is_solvent']): ?>
                            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4" role="alert">
                                <p class="font-bold"><i class="fas fa-check-circle mr-2"></i>¡Felicidades! Usted se encuentra solvente.</p>
                                <p>Puede generar una nueva Solvencia Municipal General. Esta tendrá una validez de 90 días.</p>
                            </div>
                            <div class="mt-4 text-center">
                                <a href="actions/solvency_actions.php?action=generate" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition font-bold">
                                    <i class="fas fa-file-alt mr-2"></i>Generar Solvencia Ahora
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4" role="alert">
                                <p class="font-bold"><i class="fas fa-exclamation-triangle mr-2"></i>Usted no se encuentra solvente.</p>
                                <p>Para poder generar una solvencia, debe cancelar las siguientes deudas pendientes:</p>
                            </div>
                            <ul class="mt-4 list-disc list-inside text-red-800">
                                <?php foreach ($solvencyStatus['pending_taxes'] as $tax): ?>
                                    <li><?php echo htmlspecialchars($tax['concept']); ?> - <strong><?php echo htmlspecialchars($tax['symbol']) . ' ' . number_format($tax['amount'], 2); ?></strong> (Vence: <?php echo formatDate($tax['due_date']); ?>)</li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="mt-4">
                                <a href="mis-impuestos.php" class="text-blue-500 hover:underline">Ir a Mis Impuestos para Pagar &rarr;</a>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="bg-white p-6 rounded-lg shadow-md">
                        <h3 class="text-lg font-semibold border-b pb-3 mb-4">Historial de Solvencias Emitidas</h3>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="p-2 text-left text-sm">Fecha Emisión</th>
                                        <th class="p-2 text-left text-sm">Fecha Vencimiento</th>
                                        <th class="p-2 text-left text-sm">Código de Verificación</th>
                                        <th class="p-2 text-center text-sm">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($solvencyHistory)): ?>
                                        <tr><td colspan="4" class="p-3 text-center text-gray-500">No tiene solvencias en su historial.</td></tr>
                                    <?php else: ?>
                                        <?php foreach ($solvencyHistory as $solvency): ?>
                                        <tr class="border-b">
                                            <td class="p-2"><?php echo formatDate($solvency['issue_date']); ?></td>
                                            <td class="p-2"><?php echo formatDate($solvency['expiry_date']); ?></td>
                                            <td class="p-2 font-mono text-xs"><?php echo htmlspecialchars($solvency['unique_code']); ?></td>
                                            <td class="p-2 text-center">
                                                <a href="generar_solvencia_pdf.php?id=<?php echo $solvency['id']; ?>" class="text-blue-500 hover:underline text-sm"><i class="fas fa-download mr-1"></i>Descargar</a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>